<?php
/**
 * Mark User Spam
 *
 * @package     AutomatorWP\Integrations\BuddyPress\Actions\Mark_User_Spam
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyPress_Mark_User_Spam extends AutomatorWP_Integration_Action {

    public $integration = 'buddypress';
    public $action = 'buddypress_mark_user_spam';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark user as spam', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark user as <strong>spam</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: User. */
            'edit_label'        => sprintf( __( 'Mark %1$s as spam', 'automatorwp-pro' ), '{user}' ),
            /* translators: %1$s: User. */
            'log_label'         => sprintf( __( 'Mark  %1$s as spam', 'automatorwp-pro' ), '{user}' ),
            'options'           => array(
                'user' => array(
                    'from' => 'user',
                    'default' => __( 'user', 'automatorwp-pro' ),
                    'fields' => array(
                        'user' => array(
                            'name' => __( 'User ID:', 'automatorwp-pro' ),
                            'desc' => __( 'User ID that will get mark as spam. Leave blank to mark the user that completes the automation.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $user_id_to_mark_spam = absint( $action_options['user'] );

        if( $user_id_to_mark_spam === 0 ) {
            $user_id_to_mark_spam = $user_id;
        }

        // Mark user as spam
        bp_core_mark_user_spam_admin( $user_id_to_mark_spam );

    }

}

new AutomatorWP_BuddyPress_Mark_User_Spam();